<?php
/*[Information]======================[http://www.deeemm.com]==

	DeeEmm Dolphin Sitemap Version 1.3
	Created on 23/10/2009 10:15 
	by DeeEmm AKA Mick Percy deeemm@deeemm.com
	
	DeeEmm Web Technologies 
	PO Box 2105
	Hilton Plaza
	SA 5033
	Australia
		
--[Usage]-----------------------------------------------------

	This file automatically creates a valid XML sitemap suitable 
	for submission to Google.
	
	Simply copy this file to your webroot. Then	submit the 
	following URL to Google
	
	http://yoursite.com/sitemap.php

--[Compatibility]---------------------------------------------

	This MOD has been tested on Dolphin version 7.0.2 	

--[Support]---------------------------------------------------

	Support for this mod is provided via the support forum at 
	DeeEmm.com Additional support is also given to purchasers 
	of premium mods and premium subscribers via the helpdesk 
	at www.DeeEmm.com
	
--[Bug Tracking / Feature Requests]---------------------------

	Please report all bugs by sending an email to 
	support@deeemm.com Please include MOD name in email 
	subject, and a detailed outline of how to reproduce the 
	error.
	
--[Copyright]-------------------------------------------------

	This modification and all constituent files, including 
	this file are copyright (C)2010 DeeEmm AKA Mick Percy. 
	All rights are reserved.

--[License]---------------------------------------------------

	This MOD is free to use for commercial and non-commercial 
	use under the LGPL License, a copy of which is available 
	at http://www.opensource.org/licenses/lgpl-2.1.php 

--[Changelog]-------------------------------------------------

	23/10/2009 Version 1.0 - Not publicly released 
	06/07/2010 Version 1.1 - Updated for Dolphin 7
	05/08/2010 Version 1.2 - Fixed duplicate entries
	11/08/2010 Version 1.3 - Fixed validation error

--[Remember]--------------------------------------------------

	Always back up both your files and database BEFORE trying 
	any modification. If you're not sure how to do it - Pay a 
	professional to do it for you. contact me on 
	deeemm@deeemm.com for rates / availability.
	
=====================================[http://www.deeemm.com]*/

//Comment & uncomment required modules as necessary

//$aModulesToParse[] = 'Ads';
$aModulesToParse[] = 'Blogs';
$aModulesToParse[] = 'Articles';
$aModulesToParse[] = 'News';
$aModulesToParse[] = 'Forums';
$aModulesToParse[] = 'Photos';
$aModulesToParse[] = 'Sites';
$aModulesToParse[] = 'Videos';
//$aModulesToParse[] = 'Sounds';
$aModulesToParse[] = 'Events';
//$aModulesToParse[] = 'Files';
$aModulesToParse[] = 'Groups';





require_once( 'inc/header.inc.php' );
require_once( BX_DIRECTORY_PATH_INC     . 'db.inc.php' );

$SiteMap_header = '<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

$num_menu_items = db_res("SELECT MAX(Parent) FROM `sys_menu_top`");

$TopLinkQuery = mysql_query("SELECT * FROM `sys_menu_top` WHERE `Link` IN (SELECT DISTINCT `link` FROM `sys_menu_top`) AND `Visible` LIKE 'non,%' AND `Active` = '1' AND `Link` NOT LIKE '%{%' AND `Link` NOT LIKE '%&%'");
//$TopLinkQuery = mysql_query("SELECT * FROM `sys_menu_top` WHERE `Visible` LIKE 'non,%' AND `Active` = '1' AND `Link` NOT LIKE '%{%' ");
while ($top_menu_items = mysql_fetch_array($TopLinkQuery)){

	//Create main links

	$SiteMap .= "\n" . "<url>" . "\n";
	$link = explode('|',$top_menu_items['Link']);
	$SiteMap .= "<loc>" . $site['url'] . $link[0] . "</loc>". "\n";
	
	//check valid date
	if ($LastUpdated) {
		$LastMod = date("Y-m-d", (int)$LastUpdated);
		if ($LastMod && $LastMod != '1969-12-31' && $LastMod != '1970-01-01'){	
			$SiteMap .= "<lastmod>$LastMod</lastmod>". "\n";	
		}
		
		//arbitary priority
		$priority = 0.5;

		//get update frequency
		$now = getdate();
		$SecondsSinceMod = $now[0] - (int)$LastUpdated;
		switch ($SecondsSinceMod) {
			
			case ($SecondsSinceMod < 86400):
				$ChangeFrequency = 'hourly';
				break;			
			case ($SecondsSinceMod < 604800):
				$ChangeFrequency = 'daily';
				break;			
			case ($SecondsSinceMod < 2629743):
				$ChangeFrequency = 'weekly';
				break;
			case ($SecondsSinceMod < 31556926):
				$ChangeFrequency = 'monthly';
				break;			
			case ($SecondsSinceMod < 63113851 ):
				$ChangeFrequency = 'yearly';
				break;			
			case ($SecondsSinceMod > 63113851 ):
				$ChangeFrequency = 'never';
				break;			
		}
	
		$SiteMap .= "<changefreq>$ChangeFrequency</changefreq>". "\n";
	
	} else {
	
		//priority based on menu order
		$priority =  round($top_menu_items['Order'] / 30, 1);	
	}

	
	if ($top_menu_items['Parent'] == 0){
		$priority = 1;
	}
	
	$SiteMap .= "<priority>$priority</priority>". "\n";
	$SiteMap .= "</url>". "\n";
	
}	
	
	
	
//Create sublinks
	
Foreach($aModulesToParse as $sModule)	{
	

	switch ($sModule){
	
	case 'Ads':
		$DateField = 'DateTime';
		$TableName = 'bx_ads_main';
		$URLField = 'EntryUri';
		$URLPath = 'ads/entry/';
	break;
	
	case 'Blogs':
		$DateField = 'PostDate';
		$TableName = 'bx_blogs_posts';
		$URLField = 'PostUri';
		$URLPath = 'blogs/entry/';
	break;
	
	case 'Articles':
		$DateField = 'when';
		$TableName = 'bx_arl_entries';
		$URLField = 'uri';
		$URLPath = 'm/articles/view/';
	break;
	
	case 'News':
		$DateField = 'when';
		$TableName = 'bx_news_entries';
		$URLField = 'uri';
		$URLPath = 'm/news/view/';
	break;
	
	case 'Forums':
		$DateField = 'last_post_when';
		$TableName = 'bx_forum_topic';
		$URLField = 'topic_uri';
		$URLPath = 'forum/topic/';
	break;
	
	case 'Photos':
		$DateField = 'Date';
		$TableName = 'bx_photos_main';
		$URLField = 'Uri';
		$URLPath = 'm/photos/view/';
	break;
	
	case 'Sites':
		$DateField = 'date';
		$TableName = 'bx_sites_main';
		$URLField = 'entryUri';
		$URLPath = '';
	break;
	
	case 'Videos':
		$DateField = 'Date';
		$TableName = 'RayVideoFiles';
		$URLField = 'Uri';
		$URLPath = 'm/videos/view/';
	break;
	
	case 'Sounds':
		$DateField = 'Date';
		$TableName = 'RayMp3Files';
		$URLField = 'Uri';
		$URLPath = 'm/sounds/view/';
	break;
	
	case 'Events':
		$DateField = 'Date';
		$TableName = 'bx_events_main';
		$URLField = 'EntryUri';
		$URLPath = 'm/events/view/';
	break;
	
	case 'Files':
		$DateField = 'Date';
		$TableName = 'bx_files_main';
		$URLField = 'Uri';
		$URLPath = 'm/files/view/';
	break;
	
	case 'Groups':
		$DateField = 'created';
		$TableName = 'bx_groups_main';
		$URLField = 'uri';
		$URLPath = 'm/groups/view/';
	break;
	
	
	}
	
	$SubLinks = '';
	
	
	if ($TableName){ 
		$LastUpdated = db_value("SELECT MAX('{$DateField}') FROM `$TableName`"); 
	
		//Get content
		$SubLinkQuery = mysql_query("SELECT * FROM `{$TableName}` WHERE `$URLField` IN (SELECT DISTINCT `$URLField` FROM `$TableName`)");
//		$SubLinkQuery = mysql_query("SELECT * FROM `{$TableName}`");

		while ($SubLinkResult = mysql_fetch_array($SubLinkQuery)){
			$SubLinks .= "<url>" . "\n";
			$SubLinks .= "<loc>" . $site['url'] . $URLPath . $SubLinkResult[$URLField] . "</loc>". "\n";
			$LastMod = date("Y-m-d", (int)$SubLinkResult[$DateField]);
			
			//check valid date
			if ($LastMod && $LastMod != '1969-12-31' && $LastMod != '1970-01-01'){
				$SubLinks .= "<lastmod>$LastMod</lastmod>". "\n";	
			}

			//get update frequency (yeah yeah should be split into a function - but blah whatever)
			$now = getdate();
			$SecondsSinceMod = $now[0] - (int)$SubLinkResult[$DateField];
			switch ($SecondsSinceMod) {
			
				case ($SecondsSinceMod < 86400):
					$ChangeFrequency = 'hourly';
					break;			
				case ($SecondsSinceMod < 604800):
					$ChangeFrequency = 'daily';
					break;			
				case ($SecondsSinceMod < 2629743):
					$ChangeFrequency = 'weekly';
					break;
				case ($SecondsSinceMod < 31556926):
					$ChangeFrequency = 'monthly';
					break;			
				case ($SecondsSinceMod < 63113851 ):
					$ChangeFrequency = 'yearly';
					break;			
				case ($SecondsSinceMod > 63113851 ):
					$ChangeFrequency = 'never';
					break;		
			}
					
			$SubLinks .= "<changefreq>$ChangeFrequency</changefreq>". "\n";
			$SubLinks .= "<priority>1</priority>". "\n";
			$SubLinks .= "</url>". "\n";
		}
	
	}
	
	$SiteMap .= $SubLinks;	
	
}

$SiteMap_footer = '</urlset>';

echo $SiteMap_header . $SiteMap . $SiteMap_footer;

?>